export default function FinalCTA() {
  return (
    <section id="iletisim" className="py-24 px-4 sm:px-6 lg:px-8 bg-anthracite-dark">
      <div className="max-w-5xl mx-auto">
        <div className="bg-gradient-to-br from-anthracite to-anthracite-dark border border-petrol/30 rounded-sm p-12 md:p-16 text-center">
          <h2 className="text-4xl md:text-5xl font-bold text-white mb-6">
            Projenize Başlayalım
          </h2>
          <p className="text-xl text-gray-300 mb-10 max-w-2xl mx-auto">
            Endüstriyel havalandırma ve toz toplama sistemleriniz için 
            uzman ekibimizle iletişime geçin. Ücretsiz keşif ve teknik danışmanlık.
          </p>
          
          <div className="flex flex-col sm:flex-row gap-4 justify-center items-center">
            <a
              href="tel:+905551234567"
              className="bg-petrol text-white px-10 py-4 rounded-sm hover:bg-petrol-light transition-all duration-200 font-semibold text-lg inline-flex items-center gap-2"
            >
              <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
              </svg>
              Hemen Arayın
            </a>
            <a
              href="mailto:info@celep.com"
              className="border-2 border-petrol text-petrol px-10 py-4 rounded-sm hover:bg-petrol hover:text-white transition-all duration-200 font-semibold text-lg"
            >
              E-posta Gönderin
            </a>
          </div>

          <div className="mt-12 pt-8 border-t border-gray-700">
            <p className="text-gray-400 mb-4">Veya bizi ziyaret edin</p>
            <p className="text-white font-medium">
              İstanbul, Türkiye | Pazartesi - Cuma: 08:00 - 18:00
            </p>
          </div>
        </div>
      </div>
    </section>
  );
}

