export default function EmergencyService() {
  return (
    <section className="py-16 px-4 sm:px-6 lg:px-8 bg-anthracite border-y border-gray-700">
      <div className="max-w-7xl mx-auto">
        <div className="bg-gradient-to-r from-petrol/10 to-petrol/5 border-l-4 border-petrol p-8 rounded-sm">
          <div className="flex flex-col md:flex-row items-center justify-between gap-6">
            <div className="flex items-center gap-4">
              <div className="w-16 h-16 bg-petrol rounded-full flex items-center justify-center flex-shrink-0">
                <svg className="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                </svg>
              </div>
              <div>
                <h2 className="text-2xl md:text-3xl font-bold text-white mb-2">
                  24/7 Acil Servis
                </h2>
                <p className="text-gray-300">
                  Kritik durumlar için 7/24 teknik destek ve acil müdahale hizmeti
                </p>
              </div>
            </div>
            <div className="flex-shrink-0">
              <a
                href="tel:+905551234567"
                className="bg-petrol text-white px-8 py-4 rounded-sm hover:bg-petrol-light transition-all duration-200 font-semibold text-lg inline-flex items-center gap-2"
              >
                <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                </svg>
                Hemen Arayın
              </a>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}

