# CELEP - Endüstriyel Teknik Hizmetler Web Sitesi

Modern, B2B endüstriyel tesis teknik hizmetleri web sitesi. Endüstriyel havalandırma ve toz toplama sistemleri için montaj, bakım ve bileşen tedariki hizmetleri sunan bir şirket için tasarlanmıştır.

## Özellikler

- **Technical Minimalism** tasarım stili
- Dark Anthracite/Navy (#212121, #0A2239) ve Petrol Green/Teal (#008080) renk paleti
- Responsive tasarım (mobil, tablet, desktop)
- 24/7 Acil Servis vurgusu
- 3 temel hizmet bölümü (Montaj, Bakım, Bileşen Tedariki)
- 3 sayısal güven metrikleri
- Güçlü final CTA bölümü

## Teknolojiler

- Next.js 14+ (App Router)
- TypeScript
- Tailwind CSS
- React 18

## Kurulum

```bash
# Bağımlılıkları yükleyin
npm install

# Geliştirme sunucusunu başlatın
npm run dev

# Production build
npm run build
npm start
```

Tarayıcıda [http://localhost:3000](http://localhost:3000) adresini açın.

## Proje Yapısı

```
celep/
├── app/
│   ├── globals.css      # Global stiller
│   ├── layout.tsx       # Root layout
│   └── page.tsx         # Ana sayfa
├── components/
│   ├── Navigation.tsx           # Navigasyon menüsü
│   ├── HeroSection.tsx          # Hero bölümü
│   ├── EmergencyService.tsx     # 24/7 Acil Servis
│   ├── CoreServices.tsx         # 3 temel hizmet
│   ├── ConfidenceMetrics.tsx    # Güven metrikleri
│   ├── FinalCTA.tsx             # Final CTA
│   └── Footer.tsx               # Footer
├── package.json
├── tsconfig.json
├── tailwind.config.ts
└── next.config.mjs
```

## Renk Paleti

- **Anthracite Dark**: #0A2239 (Ana arka plan)
- **Anthracite**: #212121 (Kartlar ve bileşenler)
- **Petrol**: #008080 (CTA'lar ve vurgular)
- **Petrol Light**: #00A0A0 (Hover durumları)
- **Petrol Dark**: #006666 (Koyu vurgular)

## Notlar

- Görseller şu anda placeholder olarak Unsplash kullanıyor. Gerçek projede endüstriyel ekipman ve mühendis görselleri ile değiştirilmelidir.
- İletişim bilgileri (telefon, e-posta) gerçek bilgilerle güncellenmelidir.

