# CELEP - HTML Versiyonu

Komple HTML, CSS ve JavaScript ile çalışan statik web sitesi versiyonu.

## Dosya Yapısı

```
celep/
├── index.html      # Ana HTML dosyası
├── styles.css      # Tüm CSS stilleri
└── script.js       # JavaScript interaktif özellikler
```

## Kullanım

1. `index.html` dosyasını bir web tarayıcısında açın
2. Veya bir web sunucusu kullanarak çalıştırın:
   ```bash
   # Python ile
   python -m http.server 8000
   
   # Node.js ile (http-server gerekli)
   npx http-server
   ```

Tarayıcıda `http://localhost:8000` adresini açın.

## Özellikler

- ✅ Tamamen statik HTML/CSS/JavaScript
- ✅ Herhangi bir build tool gerektirmez
- ✅ Tüm Next.js özellikleri HTML'e dönüştürüldü
- ✅ Responsive tasarım
- ✅ Mobile menü toggle
- ✅ Smooth scroll
- ✅ Scroll animasyonları
- ✅ Technical Minimalism stili
- ✅ Dark Anthracite/Navy ve Petrol Green renk paleti

## Bölümler

1. **Navigation** - Sabit navigasyon menüsü (mobil uyumlu)
2. **Hero Section** - Ana başlık ve görsel
3. **Emergency Service** - 24/7 Acil Servis vurgusu
4. **Core Services** - 3 temel hizmet kartı
5. **Confidence Metrics** - 3 sayısal metrik
6. **Final CTA** - İletişim çağrısı
7. **Footer** - Alt bilgi ve linkler

## Özelleştirme

- **Renkler**: `styles.css` dosyasındaki `:root` değişkenlerini düzenleyin
- **İçerik**: `index.html` dosyasındaki metinleri güncelleyin
- **Görseller**: Unsplash URL'lerini gerçek görsellerle değiştirin
- **İletişim**: Telefon ve e-posta bilgilerini güncelleyin

## Tarayıcı Desteği

- Chrome (son 2 versiyon)
- Firefox (son 2 versiyon)
- Safari (son 2 versiyon)
- Edge (son 2 versiyon)

## Notlar

- Görseller şu anda placeholder olarak Unsplash kullanıyor
- İletişim bilgileri örnek olarak bırakıldı, gerçek bilgilerle güncellenmelidir
- Tüm animasyonlar CSS ve vanilla JavaScript ile yapıldı

